

global DataPath= "D:\课程专题\1.城市劳动经济学\Labor-2025\Data"


**GDP
use "E:\研究数据\跨国数据\data_worldpop_2024.dta",clear
drop if _n==1


keep if  dataname=="GDP (current US$)" 

reshape long year,i(countryname) j(period)

ren year v_GDP
ren period year 
label var v_GDP "GDP"


keep   countryname countrycode year v_GDP
order  countryname countrycode year v_GDP

save  "$DataPath\CH12\temp_GDP.dta",replace 


**POP
use "E:\研究数据\跨国数据\data_worldpop_2024.dta",clear
drop if _n==1


keep if  dataname=="Population, total" 

reshape long year,i(countryname) j(period)

ren year v_POP
ren period year 
label var v_POP "POPP"


keep   countryname countrycode year v_POP
order  countryname countrycode year v_POP

save  "$DataPath\CH12\temp_POP.dta",replace 


**
use  "$DataPath\CH12\pew-global-14-questions\Pew Research Global Attitudes Spring 2014 Dataset for web.dta",clear

keep if Q28>=1 & Q28<=3
gen tindex=(Q28==1)

bysort COUNTRY: egen trade=mean(tindex)
replace trade=trade*100
keep COUNTRY trade
duplicates drop COUNTRY,force 

outsheet using temp.txt,replace
insheet using temp.txt,clear
ren country countryname

replace countryname="Egypt, Arab Rep."  if countryname=="Egypt"
replace countryname="Russian Federation"  if countryname=="Russia"
replace countryname="Korea, Rep."  if countryname=="South Korea"
replace countryname="Turkiye"  if countryname=="Turkey"
replace countryname="Venezuela, RB"  if countryname=="Venezuela"
replace countryname="Viet Nam"  if countryname=="Vietnam"


save  "$DataPath\CH12\temp_trade.dta",replace 


use  "$DataPath\CH12\temp_GDP.dta",clear

merge 1:1 countryname countrycode year using  "$DataPath\CH12\temp_POP.dta"
drop _merge 

keep if year==2013

merge 1:1 countryname using  "$DataPath\CH12\temp_trade.dta"
keep if _merge==3
drop _merge 


save "$DataPath\CH12\data_attitude_trade.dta",replace 





***读者从这里开始运行即可
use "$DataPath\CH12\data_attitude_trade.dta",clear

gen LnGDPp=ln(v_GDP/v_POP)

twoway ///
  (scatter  trade LnGDPp,mcolor(gs6) msize(medlarge) msymbol(O))    ///
  ,legend(off)    scale(1.0)     scheme(s1color)     graphregion(color(white))  ///
ytitle("支持贸易(%)", size(med))                                        ///
xtitle("Ln(人均GDP)", size(med))               ///
xmtick(6(1)11)  xlabel(6(1)11, labsize(med) angle(0))   ///
ymtick(0(20)80) ylabel(0(20)80,labsize(med) angle(360))     

graph export  "$DataPath\CH12\图_12_9_国家GDP和贸易态度.png", replace width(1600)